//=============================================================================
// UT99 Extension Pack V1.0
// - Basic Edition -
// class by Shadow
// DynamicCorona, a movable Corona, also useful for some blend effects
// ----------------------------------------------------------------------------
// HudDraw, Corona is rendered in realtime by the hud using canvas
// ----------------------------------------------------------------------------
// bFilterCorona -> should hud filter corona texture ?
// CoronaColor -> custom color of corona
// bModulatedCorona -> true = modulated, false = translucent
// bAutoCorrectPos -> if true PosFix is set internally
// Scale -> U/V Size and U/V Tiling of Corona (can be stretched, 
// multiplied and so on)
// PosFix -> manual correction of relative position of corona on the canvas
// bIgnoreActors -> if true trace goes through actor ignoring collision
// if false trace stops at any actor collision cylinder...
// ----------------------------------------------------------------------------
// 3DDraw, Corona is a rendered sprite in 3D space, it's drawscale is multiplied
// by a float that represents distance player <--> corona
// ----------------------------------------------------------------------------
// DistanceFactor -> factor to control how much distance is affecting size
// bForSize/bForScale -> is scaling enabled ?, scaleglow is also supported
// CoronaSizeLimit -> min/max size while changing distance
// CoronaBrightnessLimit -> min/max scaleglow while changing distance
// bShowStats -> weither to draw some stats (distance) on players screen ?
// bReverse -> reverses output scale depending on distance
// bSperatedScales -> if true U/V Scale/Tiling is seperated, else MainScale is used
// ----------------------------------------------------------------------------
// bBlendFX -> if true ViewFog is enable, intensity relative to players view
// and angle at the Corona
// BlendFog -> color/intensity of ViewFog
// BlendScale -> speed/scale of ViewFog while changing
// bFlicker -> the Corona is flickering, "adapting" to the LT_Flicker Lighttype
//=============================================================================
class DynamicCorona expands XTEffectActors;

struct corona
{
	var() float MainScale,UScale,VScale;
	var() int MainTile,UTile,VTile;
};
struct pos
{
	var() float posX,posY;
};
struct sizer
{
	var() float min,max;
};

var() int DistanceFactor;
var() pos PosFix;
var() color CoronaColor;
var() bool bAutoCorrectPos,bSeperatedScales,bNonSquaredTile,bIgnoreActors;
var() bool bModulatedCorona,bReverse,bShowStats,bForSize,bForScaleglow,bFilterCorona,bBlendFX;
var bool bscale;
var() corona Scale;
var() vector BlendFog;
var() bool bFlicker;
var() float Distance,BlendScale;
var() sizer CoronaSizeLimit,CoronaBrightnessLimit;
var() enum ECoronaRenderType
{
	CT_HUDDraw,
	CT_3DDraw
}CoronaRenderType;

var playerpawn dood;
var bool binternalon;

function float DistanceScale()
{
	return class'XTMainUtil'.static.getdistancebetween(dood.location,location,distancefactor,bshowstats);
}
function FullSceneBlend()
{
	class'XTMainUtil'.static.fullsceneblend(false,self,blendfog,blendscale);
}
function bool Randbool()
{
	return class'XTMainUtil'.static.randbool();
}
simulated function PreBeginPlay()
{
	binternalon=true;
}
simulated event Tick(float t)
{
    if(class'xtmutator'.default.bdynamiccoronas)
	{
		if (bBlendFX)fullsceneblend();
		if(coronarendertype==ct_huddraw&&bflicker)binternalon=randbool();
		if(coronarendertype==ct_3ddraw)
        {
			if(bflicker)
			{
				if (randbool())texture=skin;
				else texture=none;	
			}
			else texture=skin;
			dood=class'XTMainUtil'.static.getlocalplayerfor(self);
			if(dood.lineofsightto(self))
			{
				drawtype=dt_sprite;
				if(bforsize)
				{
					drawscale=distancescale();
					if(drawscale>=coronasizelimit.max)drawscale=coronasizelimit.max;
					if(drawscale<=coronasizelimit.min)drawscale=coronasizelimit.min;
				}
				if (bforscaleglow)
				{
					if(!breverse)scaleglow=distancescale();
					else scaleglow=default.scaleglow/distancescale();
					if(scaleglow>=coronabrightnesslimit.max)scaleglow=coronabrightnesslimit.max;
					if(scaleglow<=coronabrightnesslimit.min)scaleglow=coronabrightnesslimit.min;
				}
			}
			else drawtype=dt_none;
		}
		else drawtype=dt_none;
	}
	else drawtype=dt_none;
}

defaultproperties
{
     DistanceFactor=512
     PosFix=(PosX=64.000000,PosY=64.000000)
     CoronaColor=(R=255,G=255,B=255)
     bAutoCorrectPos=True
     bForSize=True
     bFilterCorona=True
     Scale=(MainScale=1.000000,UScale=128.000000,VScale=128.000000,MainTile=1,UTile=1,VTile=1)
     BlendFog=(X=1.000000,Y=1.000000,Z=1.000000)
     Distance=1024.000000
     BlendScale=4.000000
     CoronaSizeLimit=(Min=0.150000,Max=0.900000)
     CoronaBrightnessLimit=(Min=0.100000,Max=1.000000)
     Texture=Texture'UT99ExtensionPack.EdStuff.S_Lensflare'
     DrawScale=0.250000
     bTravel=True
}
